/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.model;

import net.minecraft.class_2350;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.model.GeoVertex;
import software.bernie.geckolib.loading.json.raw.FaceUV;

public record GeoQuad(GeoVertex[] vertices, float normalX, float normalY, float normalZ, class_2350 direction) {
    public Vector3f normalVec() {
        return new Vector3f(this.normalX, this.normalY, this.normalZ);
    }

    public static GeoQuad build(GeoVertex[] vertices, double[] uvCoords, double[] uvSize, FaceUV.Rotation uvRotation, float texWidth, float texHeight, boolean mirror, class_2350 direction) {
        return GeoQuad.build(vertices, (float)uvCoords[0], (float)uvCoords[1], (float)uvSize[0], (float)uvSize[1], uvRotation, texWidth, texHeight, mirror, direction);
    }

    public static GeoQuad build(GeoVertex[] vertices, float u, float v, float uSize, float vSize, FaceUV.Rotation uvRotation, float texWidth, float texHeight, boolean mirror, class_2350 direction) {
        float uWidth = (u + uSize) / texWidth;
        float vHeight = (v + vSize) / texHeight;
        u /= texWidth;
        v /= texHeight;
        Vector3f normal = direction.method_23955();
        if (!mirror) {
            float tempWidth = uWidth;
            uWidth = u;
            u = tempWidth;
        } else {
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        float[] uvs = uvRotation.rotateUvs(u, v, uWidth, vHeight);
        vertices[0] = vertices[0].withUVs(uvs[0], uvs[1]);
        vertices[1] = vertices[1].withUVs(uvs[2], uvs[3]);
        vertices[2] = vertices[2].withUVs(uvs[4], uvs[5]);
        vertices[3] = vertices[3].withUVs(uvs[6], uvs[7]);
        return new GeoQuad(vertices, normal.x, normal.y, normal.z, direction);
    }

    public void render(Matrix4f pose, Vector3f normal, class_4588 vertexConsumer, int packedLight, int packedOverlay, int renderColor) {
        for (GeoVertex vertex : this.vertices()) {
            Vector4f vector4f = pose.transform(new Vector4f(vertex.posX(), vertex.posY(), vertex.posZ(), 1.0f));
            vertexConsumer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), renderColor, vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }
}

